program kalah;
{ by uja }
{ V.0.900  14.01.96:  1. spielbare Version, 2 Spieler-Modus, Key-Steuerung, }
{                     Compimove: Tiefe=1                                    }
{ V.1.000  20.01.96:  beliebige Tiefe 1 - 4, Anzeigen optimiert             }
{ V.1.010  17.02.96:  zustzliches Titelbild                                }


uses intuit,dos,crt,graph,drivers;

const imafil1='kalah1.ima'; imafil2='kalah2.ima'; imafil3='kalah3.ima';
      header='                             U J A s   K a l a h    V1.010              TP6';
      imafile='Kalah.ima'; { Gruben- und Kugelimages }

{ Grubenkoordinaten: }
      stx:array[0..7] of integer=(168,208,256,304,352,400,448,488);
      sty:array[0..2] of integer=(384,352,416);

{ Offset Kugeln in Grube: }
      blx:array[1..32] of integer=
         (34,47,38,31,22,43,27,39, 43,50,30,45,26,36,53,39,
          30,44,31,47,35,45,39,26, 48,40,33,39,49,23,31,43);
      bly:array[1..32] of integer=
         (17,11,11,09,12,06,17,21, 17,17,22,22,07,06,12,15,
          13,11,04,19,21,14,04,12, 07,08,12,18,13,16,13,10);

{ Offset Anzeige Grubeninhalt und Imagegre: }
      anzx=16; anzy=36;
      dx=48;   dy=32;

type vector=array[0..13] of integer;

var ok,aus,ende              :boolean;
    ch,csr                   :char;
    temp,t1,t2,t3,t4         :string;
    inh                      :vector;
    compi                    :array[1..2] of boolean;
    tiefe                    :array[1..2] of integer;
    g,i,mx,my,x,y,dran       :integer;

    ima                            :array[0..3] of Image;
    igad                           :array[1..8] of Gadget;
    stringinfo                     :array[1..2] of StrInfo;
    itext1,itext2                  :array[1..8] of IntuiText;
    ibord1,ibord2                  :Border;
    xy1,xy2                        :Koords;



procedure initkrams;
var i,j,k:integer;
begin
   itext1[1].itext:='Strke Compi1:';
   itext1[2].itext:='Strke Compi2:';
   itext1[3].itext:='Spieler 1';
   itext1[4].itext:='Spieler 2';
   itext1[5].itext:='   Neu   ';
   itext1[6].itext:='  Quit   ';
   itext1[7].itext:=' Compi 1 ';
   itext1[8].itext:=' Compi 2 ';

   for i:=1 to 8 do begin
      with itext1[i] do begin
         if i>2 then x:=7 else x:=-112;
         if i>2 then y:=4 else y:=2;
         fpen:=7;
         bpen:=11;
         drmode:=jam1;
         p_nexttext:=addr(itext2[i]);
      end;
      with itext2[i] do begin
         itext:=itext1[i].itext;
         if i>2 then x:=6 else x:=-113;
         if i>2 then y:=4 else y:=2;
         fpen:=0;
         bpen:=11;
         drmode:=jam1;
         p_nexttext:=nil;
      end;
   end;

   xy1[0]:=0; xy1[1]:=15; xy1[2]:=0;  xy1[3]:=0;  xy1[4]:=79; xy1[5]:=0;
   xy2[0]:=0; xy2[1]:=15; xy2[2]:=79; xy2[3]:=15; xy2[4]:=79; xy2[5]:=1;

   with ibord1 do begin
      x:=0;
      y:=0;
      fpen:=7;
      bpen:=11;
      drmode:=jam1;
      ecken:=3;
      p_ecken:=addr(xy1);
      p_nextborder:=addr(ibord2);
   end;
   with ibord2 do begin
      x:=0;
      y:=0;
      fpen:=0;
      bpen:=11;
      drmode:=jam1;
      ecken:=3;
      p_ecken:=addr(xy2);
      p_nextborder:=nil;
   end;

   for i:=1 to 2 do with stringinfo[i] do begin
      x:=4;
      y:=2;
      maxlen:=2;
      fpen:=7;
      bpen:=0;
      buff:='1';
      ubuff:='0';
   end;

   for i:=1 to 2 do with igad[i] do begin
      id:=i;
      x:=i*152-32;
      y:=466;
      width:=24;
      height:=12;
      bpen:=11;
      hibpen:=13;
      p_loborder:=nil;
      p_hiborder:=p_loborder;
      p_lointuitext:=addr(itext1[i]);
      p_hiintuitext:=p_lointuitext;
      p_loimage:=nil;
      p_hiimage:=p_loimage;
      gadgettyp:=strgadget;
      onoff:=false;
      active:=true;
      p_specialinfo:=addr(stringinfo[i]);
      p_nextgadget:=addr(igad[succ(i)]);
   end;

   for i:=3 to 6 do with igad[i] do begin
      id:=i;
      x:=i*80+80;
      y:=464;
      width:=80;
      height:=16;
      bpen:=11;
      hibpen:=12;
      p_loborder:=addr(ibord1);
      p_hiborder:=p_loborder;
      p_lointuitext:=addr(itext1[i]);
      if i<5 then p_hiintuitext:=addr(itext1[i+4])
             else p_hiintuitext:=p_lointuitext;
      p_loimage:=nil;
      p_hiimage:=p_loimage;
      gadgettyp:=boolgadget;
      onoff:=false;
      active:=true;
      p_specialinfo:=nil;
      p_nextgadget:=addr(igad[succ(i)]);
   end;

   i:=7;
   with igad[i] do begin
      id:=i;
      x:=208;
      y:=352;
      width:=288;
      height:=96;
      bpen:=-1;
      hibpen:=bpen;
      p_loborder:=nil;
      p_hiborder:=p_loborder;
      p_lointuitext:=nil;
      p_hiintuitext:=nil;
      p_loimage:=nil;
      p_hiimage:=p_loimage;
      gadgettyp:=boolgadget;
      onoff:=false;
      active:=true;
      p_specialinfo:=nil;
      p_nextgadget:=nil;
   end;


end;


procedure darken;
var i:integer;
begin
   for i:=1 to 15 do setpalette(i,0);
end;

procedure lighten;
var i:integer;
begin
   for i:=1 to 15 do setpalette(i,i);
end;

procedure initfarben(var ok:boolean);
const pal:array[0..15,0..2] of integer=
(( 0,  4,  0),(  2, 30, 30),(  6, 34, 34),( 11, 38, 38),
( 16, 43, 43),( 23, 47, 47),( 30, 51, 51),( 39, 56, 56),
( 31,  0,  0),( 37,  9,  4),( 44, 22, 12),( 51, 35, 21),
( 54, 41, 30),( 57, 48, 40),( 60, 55, 51),( 63, 63, 63));
var i:integer;
begin
   initscreen(ok);
   if ok then for i:=0 to 15 do begin
      setrgbpalette(i,pal[i,0],pal[i,1],pal[i,2]);
      setpalette(i,0)
   end;
end;



procedure titelbild;
var ima0:image;
    fh:file;
    size:word;
begin
   RectFill(0,0,639,479,0);
   assign(fh,'kalahb1.ima');
   reset(fh,1);
   Blockread(fh,ima0,sizeof(image));
   with ima0 do begin
      size:=Imagesize(1,1,width,height);
      Getmem(p_data,size);
      BlockRead(fh,p_data^,size);
      putimage(0,0,p_data^,normalput);
      Freemem(p_data,size);
   end;
   close(fh);
   assign(fh,'kalahb2.ima');
   reset(fh,1);
   Blockread(fh,ima0,sizeof(image));
   with ima0 do begin
      size:=Imagesize(1,1,width,height);
      Getmem(p_data,size);
      BlockRead(fh,p_data^,size);
      putimage(160,0,p_data^,normalput);
      Freemem(p_data,size);
   end;
   close(fh);
   assign(fh,'kalahb3.ima');
   reset(fh,1);
   Blockread(fh,ima0,sizeof(image));
   with ima0 do begin
      size:=Imagesize(1,1,width,height);
      Getmem(p_data,size);
      BlockRead(fh,p_data^,size);
      putimage(320,0,p_data^,normalput);
      Freemem(p_data,size);
   end;
   close(fh);
   assign(fh,'kalahb4.ima');
   reset(fh,1);
   Blockread(fh,ima0,sizeof(image));
   with ima0 do begin
      size:=Imagesize(1,1,width,height);
      Getmem(p_data,size);
      BlockRead(fh,p_data^,size);
      putimage(480,0,p_data^,normalput);
      Freemem(p_data,size);
   end;
   close(fh);
end;



procedure starttext;
var ch:char;
    t:string;
begin
   titelbild;
   t:='K';
   SetTextStyle(gothicfont,horizdir,8);
   Setcolor(0);
   outtextxy(76,40,t);
   Setcolor(15);
   outtextxy(78,42,t);
   Setcolor(8);
   outtextxy(80,44,t);
   outtextxy(81,45,t);
   outtextxy(82,46,t);

   SetTextStyle(gothicfont,horizdir,2);
   Setcolor(0);
   t:='alah,das Spiel der Wste mit Kugeln und Gruben ';
   outtextxy(128,88,t);


   SetTextStyle(DefaultFont,horizdir,1);
   lighten;
   ch:=readkey;
   darken;
end;

procedure feddich(t1,t2:string);
var ch:char;
    t:string;
begin
   darken;
   titelbild;
   t:=t1[1];
   SetTextStyle(gothicfont,horizdir,8);
   Setcolor(0);
   outtextxy(76,40,t);
   Setcolor(15);
   outtextxy(78,42,t);
   Setcolor(8);
   outtextxy(80,44,t);
   outtextxy(81,45,t);
   outtextxy(82,46,t);

   SetTextStyle(gothicfont,horizdir,2);
   Setcolor(0);
   t:=copy(t1,2,length(t1)-1);
   outtextxy(128,88,t);

   t:=t2[1];
   SetTextStyle(gothicfont,horizdir,8);
   Setcolor(0);
   outtextxy(176,140,t);
   Setcolor(15);
   outtextxy(178,142,t);
   Setcolor(8);
   outtextxy(180,144,t);
   outtextxy(181,145,t);
   outtextxy(182,146,t);

   SetTextStyle(gothicfont,horizdir,2);
   Setcolor(0);
   t:=copy(t2,2,length(t2)-1);
   outtextxy(228,188,t);

   SetTextStyle(DefaultFont,horizdir,1);
   lighten;
   ch:=readkey;
   darken;
end;





procedure hintergrund;
var ima0:image;
    size:longint;
    i   :integer;
    fh  :file;
    temp:string;

begin
   rectfill(0,0,639,15,12);
   setcolor(15);
   line(0,0,0,15);
   line(0,0,639,0);
   setcolor(8);
   line(0,15,639,15);
   line(639,1,639,15);
   setcolor(15);
   outtextxy(25,4,header);
   setcolor(0);
   outtextxy(24,4,header);


   rectfill(0,464,639,479,12);
   setcolor(15);
   line(0,464,0,479);
   line(0,464,639,464);
   setcolor(8);
   line(0,479,639,479);
   line(639,465,639,479);

{ Hintergrundbild: }
   assign(fh,imafil1);
   reset(fh,1);
   Blockread(fh,ima0,sizeof(image));
   with ima0 do begin
      size:=Imagesize(1,1,width,height);
      Getmem(p_data,size);
      BlockRead(fh,p_data^,size);
      putimage(0,16,p_data^,normalput);
      Freemem(p_data,size);
   end;
   close(fh);

   assign(fh,imafil2);
   reset(fh,1);
   Blockread(fh,ima0,sizeof(image));
   with ima0 do begin
      size:=Imagesize(1,1,width,height);
      Getmem(p_data,size);
      BlockRead(fh,p_data^,size);
      putimage(256,16,p_data^,normalput);
      Freemem(p_data,size);
   end;
   close(fh);

   assign(fh,imafil3);
   reset(fh,1);
   Blockread(fh,ima0,sizeof(image));
   with ima0 do begin
      size:=Imagesize(1,1,width,height);
      Getmem(p_data,size);
      BlockRead(fh,p_data^,size);
      putimage(512,16,p_data^,normalput);
      Freemem(p_data,size);
   end;
   close(fh);
   lighten;
end;


procedure holeimages;
var size:longint;
    i   :integer;
    fh  :file;
    temp:string;
begin
{ Images fr das Spiel: }
   assign(fh,imafile);
   reset(fh,1);
   for i:=0 to 3 do begin
      Blockread(fh,ima[i],sizeof(image));
      with ima[i] do begin
         size:=Imagesize(1,1,width,height);
         Getmem(p_data,size);
         BlockRead(fh,p_data^,size);
      end;
   end;
   close(fh);
end;
{ ---------------------------------------------------------------------- }

procedure hilfe;
var weiter:boolean;
begin
setcolor(0);
outtextxy(208,20,'Ziel: mglichst viele Kugeln im ''Kalah'' zu sammeln');
outtextxy(208,28,'Schale whlen, der Inhalt wird im Uhrzeigersinn ver-');
outtextxy(208,36,'teilt. Endet die letzte Kugel in einer gegnerischen ');
outtextxy(208,44,'Schale mit nur 1 oder 2 Kugeln, so werden alle Kugeln');
outtextxy(208,52,'dieser Schale kassiert. Schafft man es wieder bis zum');
outtextxy(208,60,'eigenen Bereich, so darf man nochmal whlen');
end;

{ ---------------------------------------------------------------------- }
procedure grube(n,m:integer);
{ zeichnet Grube n mit Inhalt m }
var i,x,y,z:integer;
    temp   :string;
begin
   case n of
     0,7: begin x:=stx[n];    y:=sty[0] end;
   1.. 6: begin x:=stx[n];    y:=sty[1] end;
   8..13: begin x:=stx[14-n]; y:=sty[2] end;
   end;
   putimage(x,y,ima[0].p_data^,andput);
   putimage(x,y,ima[1].p_data^,orput);
   if m>0 then begin
      if m>32 then z:=32 else z:=m;
      for i:=1 to z do begin
         putimage(x+blx[i]-16,y+bly[i],ima[2].p_data^,andput);
         putimage(x+blx[i]-16,y+bly[i],ima[3].p_data^,orput);
      end;
   end;
   x:=x+anzx;
   y:=y+anzy;
   rectfill(x-1,y-1,x+23,y+11,8);
   str(m:2,temp);
   setcolor(0);
   outtextxy(x-1,y,temp);
   outtextxy(x+1,y,temp);
   if (n>0) and (n<8) then setcolor(11) else setcolor(3);
   outtextxy(x,y,temp);
end;

procedure messi(dran:integer; temp:string);
begin
rectfill(224,400,479,409,8);
setcolor(0);
outtextxy(224,401,temp);
outtextxy(226,401,temp);
outtextxy(225,402,temp);
outtextxy(225,400,temp);
case dran of
0: setcolor(10);
1: setcolor(6);
2: setcolor(13);
end;
outtextxy(225,401,temp);
end;

{ --------------------------------------------------------------------- }

function checkit(dran:integer):boolean;
var i,k:integer;
    ok :boolean;
begin
   ok:=false;
   if dran=2 then for i:=1 to 6  do if inh[i]>0 then ok:=true;
   if dran=1 then for i:=8 to 13 do if inh[i]>0 then ok:=true;
   checkit:=ok;
end;

{ --- }

function checkende:boolean;
var i,k:integer;
    ok :boolean;
begin
   ok:=false;
   for i:=1 to 13  do if i<>7 then if inh[i]>0 then ok:=true;
   checkende:=ok;
end;

{ --- }

function regeln(dran,x,y:integer):boolean;
var i,j:integer;
    ok:boolean;
begin
   ok:=(y=dran);
   if ok then begin
      if dran=2 then i:=x else i:=14-x;
      ok:=inh[i]>0;
      if not ok then begin
         messi(dran,' da sind keine Kugeln drin!');
         sound(50);
         delay(100);
         nosound;
         delay(900);
      end;
   end else begin
      messi(dran,' ... das ist nicht Dein Bereich!');
      sound(50);
      delay(100);
      nosound;
      delay(900);
   end;
   regeln:=ok;
end;

{ --- }

procedure durchziehen(var dran,x:integer; var inh:vector; flag:boolean);
{ Kugeln verteilen auf die Schalen }
var i,k,anz:integer;
    runde  :boolean;
begin
   runde:=false;
   anz:=inh[x];
   inh[x]:=0;
   if flag then grube(x,inh[x]);
   k:=x;
   for i:=1 to anz do begin
      inc(k);
      if k=7 then if dran=1 then begin
         inc(k);
         runde:=true;
      end;
      if k=14 then begin
         k:=0;
         if dran=2 then begin
            inc(k);
            runde:=true;
         end;
      end;
      inh[k]:=succ(inh[k]);
      if flag then grube(k,inh[k]);
   end;

{ Reste kassieren, wenn 1 oder 2 Kugeln in der Schale waren: }
   if dran=2 then while ((inh[k]=2) or (inh[k]=3)) and (k>7) do begin
      inh[7]:=inh[7]+inh[k];
      inh[k]:=0;
      if flag then grube(k,inh[k]);
      if flag then grube(7,inh[7]);
      dec(k);
   end;
   if dran=1 then if k<7 then while ((inh[k]=2) or (inh[k]=3)) and (k>0) do begin
      inh[0]:=inh[0]+inh[k];
      inh[k]:=0;
      if flag then grube(k,inh[k]);
      if flag then grube(0,inh[0]);
      dec(k);
   end;

{ Ehrenrunde, wenn man wieder im eigenen Feld ist: }
   if runde then dran:=succ(dran mod 2);
end;

{ --- }

procedure initgame;
var i:integer;
begin
   randomize;
   for i:=1 to 13 do inh[i]:=succ(random(5));
   inh[0]:=0;
   inh[7]:=0;
   for i:=0 to 13 do grube(i,inh[i]);
end;

{ ---------------------------------------------------------------------- }
procedure getopt(var dran,tiefe,x:integer; var liste:vector);
var i,j,k,wert,x2,gain:integer;
    lista             :vector;
begin
   x:=0;
   wert:=-9999;
   for i:=1 to 6 do begin
      if dran=2 then k:=i else k:=7+i;
      if liste[k]>0 then begin
         lista:=liste;
         durchziehen(dran,k,lista,false);
         if tiefe>1 then begin
            tiefe:=pred(tiefe);
            dran:=succ(dran mod 2);
            getopt(dran,tiefe,x2,lista);
            if x2>0 then durchziehen(dran,x2,lista,false);
            dran:=succ(dran mod 2);
            tiefe:=succ(tiefe);
         end;
         if dran=2 then gain:=lista[7]-lista[0]
                   else gain:=lista[0]-lista[7];
         if gain>=wert then begin
            wert:=gain;
            x:=k;
         end;
      end;
   end;
end;

{ --- }

procedure compimove(dran,tiefe:integer; var liste:vector);
var x:integer;
    t:string;
begin
   messi(dran,' ich berlege...');
   getopt(dran,tiefe,x,liste);
   if x=0 then messi(dran,' ich mu aussetzen...') else begin
      durchziehen(dran,x,liste,true);
      if dran=1 then x:=14-x;
      str(x:2,t);
      messi(dran,'... ich nehme '+t);
   end;
   delay(1000);
end;

{ ====================================================================== }

begin
initfarben(ok);
if ok then begin
   starttext;
   darken;
   holeimages;
   hintergrund;
   lighten;
   initkrams;
   hilfe;
   igad[1].p_specialinfo^.buff:='1';
   igad[2].p_specialinfo^.buff:='1';

   for i:=1 to 2 do begin
      igad[i+2].onoff:=false;
      compi[i]:=igad[i+2].onoff;
      val(igad[i].p_specialinfo^.buff,tiefe[i],g);
   end;
   RefreshGadgets(addr(igad[1]));

   initmouse;
   ende:=false;
   while not ende do begin
      initgame;
      dran:=1;
      aus:=false;
      while not (aus or ende) do begin
         if compi[dran] then begin
            messi(dran,'   ... ich berlege...');
            if checkit(dran) then begin
               compimove(dran,tiefe[dran],inh);
               aus:=not checkende;
            end else begin
               messi(dran,' ... ich mu aussetzen');
            end;
            dran:=succ(dran mod 2);
         end;

         { Spieleraktion }
         showmouse;
         if not compi[dran] then begin
             if checkit(dran) then messi(dran,' ... bitte whlen:')
                              else messi(dran,' Du mut aussetzen!');
         end;
         repeat
            getgadget(addr(igad[1]),g,mx,my);
            if keypressed then begin
               ch:=readkey;
               case ch of
               #27,'Q','q': g:=6;
               'C','c':     g:=4;
               'N','n':     g:=5;
               '1'..'6':    begin
                               val(ch,i,g);
                               g:=7;
                               mx:=pred(i)*dx+stx[1];
                               my:=succ(sty[succ(dran mod 2)]);
                            end;
               end;
            end;
         until (g>0) or compi[dran];
         hidemouse;
         case g of
         1,2:   with igad[g] do begin
                   stringinfo[g].ubuff:=stringinfo[g].buff;
                   stringinfo[g].buff:='';
                   i:=0;
                   csr:='_';
                   while keypressed do ch:=readkey;
                   ch:='+';
                   rectfill(x,y,x+pred(width),y+pred(height),stringinfo[g].bpen);
                   setcolor(stringinfo[g].fpen);
                   outtextxy(x+stringinfo[g].x,y+stringinfo[g].y,stringinfo[g].buff+csr);
                   while (i<stringinfo[g].maxlen) and (ch<>#13) do
                   if keypressed then begin
                      ch:=readkey;
                      if (ch>#31) and (ch<#255) then begin
                         stringinfo[g].buff:=stringinfo[g].buff+ch;
                         inc(i);
                      end;
                      if ch=#8 then if i>0 then begin { backspace }
                         delete(stringinfo[g].buff,i,1);
                         dec(i);
                      end;
                      if ch=#27 then begin
                         stringinfo[g].buff:=stringinfo[g].ubuff;
                         i:=0;
                      end;
                      rectfill(x,y,x+pred(width),y+pred(height),stringinfo[g].bpen);
                      setcolor(stringinfo[g].fpen);
                      outtextxy(x+stringinfo[g].x,y+stringinfo[g].y,stringinfo[g].buff+csr);
                  end; { keypressed }

                  val(stringinfo[g].buff,tiefe[g],i);
                  if tiefe[g]<1 then tiefe[g]:=1;
                  if tiefe[g]>6 then tiefe[g]:=6;
                  str(tiefe[g]:2,stringinfo[g].buff);
                  DrawGadget(addr(igad[g]));

              end;
         3,4: begin
                 compi[g-2]:=not compi[g-2];
                 igad[g].onoff:=compi[g-2];
                 DrawGadget(addr(igad[g]));
              end;
         5:   aus:=true;
         6:   ende:=true;
         7:   if not compi[dran] then if checkit(dran) then begin
                 x:=succ((mx-stx[1]) div dx);
                 y:=0;
                 if (my>sty[1]) and (my<(sty[1]+dy)) then y:=2;
                 if (my>sty[2]) and (my<(sty[2]+dy)) then y:=1;
                 if regeln(dran,x,y) then begin
                    messi(dran,' ... wird durchgefhrt!');
                    if dran=1 then x:=14-x;
                    durchziehen(dran,x,inh,true);
                    aus:=not checkende;
                    dran:=succ(dran mod 2);
                 end;
                 delay(1000);
              end else begin
                 messi(dran,'   ... Du mut aussetzen');
                 dran:=succ(dran mod 2);
              end;
         end;

      end; { aus-Loop }
      if aus then begin
         str(inh[0]:2,t1);
         str(inh[7]:2,t2);
         if compi[1] then t3:='C ompi 1' else t3:='S pieler 1';
         if compi[2] then t4:='C ompi 2' else t4:='S pieler 2';
         feddich(t3+' erhielt '+t1+' Kugeln...',t4+' erhielt '+t2+' Kugeln...');

         hintergrund;
         RefreshGadgets(addr(igad[1]));
      end;
   end; { outer loop }

end;  { init ok }
textmode(3);
end.
